﻿using BMS.MT;
using System;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.Translators
{
    public static class TranslatorBedUnavailableHistory
    {
        public static void CopyTo(this DataContracts.BedUnavailableHistory bedUnavailable, BedUnavailableHistoryBO bedUnavailableBO)
        {
            bedUnavailableBO.CREATION_DATE.Value = bedUnavailable.CreationDate;
            if (bedUnavailable.Type != null)
            {
                bedUnavailableBO.TYPE_CODE.Value = bedUnavailable.Type.code;
                bedUnavailableBO.TYPE_CODE_SYSTEM.Value = bedUnavailable.Type.codeSystem;
                bedUnavailableBO.TYPE_CODE_SYSTEM_NAME.Value = bedUnavailable.Type.codeSystemName;
                bedUnavailableBO.TYPE_DISPLAY_NAME.Value = bedUnavailable.Type.displayName;
            }
            if (bedUnavailable.Reason != null)
            {
                bedUnavailableBO.REASON_CODE.Value = bedUnavailable.Reason.code;
                bedUnavailableBO.REASON_CODE_SYSTEM.Value = bedUnavailable.Reason.codeSystem;
                bedUnavailableBO.REASON_CODE_SYSTEM_NAME.Value = bedUnavailable.Reason.codeSystemName;
                bedUnavailableBO.REASON_DISPLAY_NAME.Value = bedUnavailable.Reason.displayName;
            }
            if (bedUnavailable.DivisionId != null)
                bedUnavailableBO.DIVISION_UID.Value = System.Guid.Parse(bedUnavailable.DivisionId.extension);                
            if (bedUnavailable.BedId != null)
                bedUnavailableBO.BED_UID.Value = System.Guid.Parse(bedUnavailable.BedId.extension);                
            bedUnavailableBO.CREATED_BY.Value = bedUnavailable.CreatedBy;
            bedUnavailableBO.EDITED_BY.Value = bedUnavailable.EditedBy;
            bedUnavailableBO.EDITED_DATE.Value = bedUnavailable.EditedDate;
            bedUnavailableBO.COMPLETED_BY.Value = bedUnavailable.CanceledBy;
            bedUnavailableBO.COMPLETED_DATE.Value = bedUnavailable.CanceledDate;
            if (bedUnavailable.VistaSiteId != null)
                bedUnavailableBO.VISTA_SITE_UID.Value = System.Guid.Parse(bedUnavailable.VistaSiteId.extension);            
            bedUnavailableBO.DIVISION_LIST.Value = string.Empty;
            if (bedUnavailable.DivisionList != null && bedUnavailable.DivisionList.Count > 0)
            {
                foreach (II id in bedUnavailable.DivisionList)
                    bedUnavailableBO.DIVISION_LIST.Value += id.extension + ",";
            }
            bedUnavailableBO.IS_CHANGED_ONLY_COMMENT.Value = bedUnavailable.IsChangeOnlyComment;
            bedUnavailableBO.IS_CLEAR_ALL.Value = bedUnavailable.IsClearAll;
            bedUnavailableBO.COMMENT.Value = bedUnavailable.Comment;
            bedUnavailableBO.EXPECTED_COMPLETED_DATE.Value = bedUnavailable.ExpectedCompletedDate;
        }
    }
}
